--[[
    script by:          Noëmi Andriesse
    date first written: 24-10-2022
    version:            0.9
    most recent edits:  15-06-2023

    TO DO:              ! export functionality preferably through csv file output
                        !? dikte materialen haalt soms 2 mm weg (bij ladetype regulier)
                        - ipv losse knop select origin hoogtepunt laten selecteren na p1 en p2 van binnencorpusmaten
                        -----------------------------------------------------------------------------
                        ! = priority    /   - = do, non priority    /   ? = optional
]]

function main()
    local data = {
        referentie = "KIMA drawer",
        size = {nil, 250, 0}, 
        model = "regulier", 
        material_main = nil, 
        thickness_main = nil, 
        material_bottom = nil, 
        thickness_bottom = nil, 
        origin= {0,0,0}, 
        ref_start = {0,0,0},
        ref_end = nil, 
        rot_angle = nil, 
        mat_massief = nil, 
        geleider = "None", 
        setback = get_value("setback"), 
        opvullijst_l = false, 
        opvullijst_r = false, 
        opvullijst_kleur = "Wit", 
        gemonteerd = false, 
        synchronisatiestang = false, 
        diepteversteller = false,
        tip_on_set = "None",
        corrected_width = nil
    }
    
    material_list = {}
    get_materials(material_list)

    local checkForData = clear_data_file()
    if checkForData == false then 
        pyio.save_values("default_values", {setback = data.setback})
    else 
        data.size[2] = get_value("diepte")
        data.size[3] = get_value("hoogte")
        data.model = get_value("model")
        data.material_main = get_value("hoofdmat")
        data.thickness_main = get_value("hoofd_dikte")
        data.material_bottom = get_value("bodemmat")
        data.thickness_bottom = round(get_value("bodem_dikte"), 1)
        data.mat_massief = get_value("massief")
        data.geleider = get_value("geleider")
        data.opvullijst_l = get_value("opvul_l")
        data.opvullijst_r = get_value("opvul_r")
        data.opvullijst_kleur = get_value("opvul_kleur")
        data.gemonteerd = get_value("gemonteerd")
        data.synchronisatiestang = get_value("synchronisatiestang")
        data.diepteversteller = get_value("diepteversteller")
        data.tip_on_set = get_value("tip_on")
    end

    pyui.run_modal_dialog(setModel_dialog, data, false)

    if data.geleider == "40kg tip-on" or data.geleider == "60kg tip-on" then 
        data.synchronisatiestang = false
        data.tip_on_set = "None"
    end

    pyio.save_values("default_values",{
        diepte = data.size[2], 
        hoogte = data.size[3], 
        model = data.model, 
        hoofdmat = data.material_main, 
        hoofd_dikte = data.thickness_main, 
        bodemmat = data.material_bottom, 
        bodem_dikte = data.thickness_bottom, 
        massief = data.mat_massief, 
        geleider = data.geleider, 
        setback = data.setback, 
        opvul_l = data.opvullijst_l, 
        opvul_r = data.opvullijst_r,  
        opvul_kleur = data.opvullijst_kleur, 
        gemonteerd = data.gemonteerd, 
        synchronisatiestang = data.synchronisatiestang, 
        diepteversteller = data.diepteversteller, 
        tip_on = data.tip_on_set 
    })
    
    if data.model == "regulier" then
        create_lade_regulier(data, material_list)
    elseif data.model == "engels" then
        create_lade_engels(data, material_list)
    elseif data.model == "voortegen" then
        create_lade_voortegen(data, material_list)
    end
end

function setModel_dialog(dialog, data, defined_bc)
    dialog:set_window_title(pyloc "KIMA drawer generator")
    
    local ref_label = dialog:create_label(1, pyloc "Reference")
    local referentie = dialog:create_text_box({2,4}, data.referentie)

    local select_model = dialog:create_label(1, pyloc "Select the drawer model")
    local modeltype = dialog:create_drop_list(2)
    modeltype: insert_control_item(pyloc "Drawer")
    modeltype: insert_control_item(pyloc "Internal drawer C-handle")
    modeltype: insert_control_item(pyloc "Internal drawer full front")

    local label_setback= dialog:create_label(3, pyloc "Setback in mm")
    local setback = dialog:create_text_box(4, data.setback)

    local label_mainm = dialog:create_label(1, pyloc "Main material")
    local hoofdmat = dialog: create_drop_list({2,3})
    hoofdmat: insert_control_item(pyloc "Select material")

    local thickness_main = dialog:create_drop_list(4)
    pyui.enable_control(thickness_main, false)

    local label_botm = dialog:create_label(1, pyloc "Bottom material")
    local bottommat = dialog: create_drop_list({2,3})
    if data.material_bottom == nil then bottommat: insert_control_item(pyloc "Select material") end
    bottommat: insert_control_item(pyloc "Black")
    bottommat: insert_control_item(pyloc "White")
    bottommat: insert_control_item(pyloc "Anthracite grey")
    bottommat: insert_control_item(pyloc "Oak")
    bottommat: insert_control_item(pyloc "Beech")
    bottommat: insert_control_item(pyloc "Walnut")
    bottommat: insert_control_item(pyloc "Anti-slip")

    local thickness_bottom = dialog:create_drop_list(4)
    pyui.enable_control(thickness_bottom, false)

    if data.material_bottom == "melamine_zwart" then 
        pyui.set_control_selection(bottommat, 1)
        thickness_bottom: insert_control_item("4 mm")
        thickness_bottom: insert_control_item("10 mm")
        pyui.enable_control(thickness_bottom, true)
        if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
        elseif data.thickness_bottom == 10 then pyui.set_control_selection(thickness_bottom, 2)
        end
    elseif data.material_bottom == "melamine_wit" then 
        pyui.set_control_selection(bottommat, 2)
        thickness_bottom: insert_control_item("4 mm")
        thickness_bottom: insert_control_item("10 mm")
        pyui.enable_control(thickness_bottom, true)
        if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
        elseif data.thickness_bottom == 10 then pyui.set_control_selection(thickness_bottom, 2)
        end
    elseif data.material_bottom == "melamine_antraciet" then 
        pyui.set_control_selection(bottommat, 3)
        thickness_bottom: insert_control_item("10 mm")
        pyui.enable_control(thickness_bottom, false)
    elseif data.material_bottom == "eiken_massief" then 
        pyui.set_control_selection(bottommat, 4)   
        thickness_bottom: insert_control_item("9 mm")
        pyui.enable_control(thickness_bottom, false) 
    elseif data.material_bottom == "beuken_massief" then 
        pyui.set_control_selection(bottommat, 5)
        thickness_bottom: insert_control_item("4 mm")
        thickness_bottom: insert_control_item("9 mm")
        pyui.enable_control(thickness_bottom, true)
        if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
        elseif data.thickness_bottom == 9 then pyui.set_control_selection(thickness_bottom, 2)
        end
    elseif data.material_bottom == "noten_massief" then 
        pyui.set_control_selection(bottommat, 6)
        thickness_bottom: insert_control_item("10 mm")
        pyui.enable_control(thickness_bottom, false)
    elseif data.material_bottom == "anti_slip" then 
        pyui.set_control_selection(bottommat, 7)
        thickness_bottom: insert_control_item("11.2 mm")
        pyui.enable_control(thickness_bottom, false)
    end

    local label_bc = dialog:create_label(1, pyloc "Internal cabinet width")
    
    local select_bc_points_button = dialog:create_button({2,3}, pyloc "Select width, direction and origin")
    if defined_bc then select_bc_points_button:set_control_text(round(data.size[1], 1).." mm") end
    
    -- local select_origin_button = dialog:create_button(3, pyloc "Select origin")
    local manual_input_button = dialog:create_button(4, pyloc "Manual input")

    local label_h = dialog:create_label(1, pyloc "Height")    
    local sizeZ = dialog: create_drop_list(2)
    pyui.enable_control(sizeZ, false)

    local label_nl = dialog:create_label(3, pyloc "Nominal depth")
    local sizeY = dialog: create_drop_list(4)
    sizeY: insert_control_item("250 mm")
    sizeY: insert_control_item("270 mm")
    sizeY: insert_control_item("300 mm")
    sizeY: insert_control_item("320 mm")
    sizeY: insert_control_item("350 mm")
    sizeY: insert_control_item("380 mm")
    sizeY: insert_control_item("400 mm")
    sizeY: insert_control_item("420 mm")
    sizeY: insert_control_item("450 mm")
    sizeY: insert_control_item("480 mm")
    sizeY: insert_control_item("500 mm")
    sizeY: insert_control_item("520 mm")
    sizeY: insert_control_item("550 mm")
    sizeY: insert_control_item("600 mm")
    sizeY: insert_control_item("650 mm")
    sizeY: insert_control_item("700 mm")
    sizeY: insert_control_item("750 mm")
    if data.size[2] == 250 then pyui.set_control_selection(sizeY, 1)
    elseif data.size[2] == 270 then pyui.set_control_selection(sizeY, 2)
    elseif data.size[2] == 300 then pyui.set_control_selection(sizeY, 3)
    elseif data.size[2] == 320 then pyui.set_control_selection(sizeY, 4)
    elseif data.size[2] == 350 then pyui.set_control_selection(sizeY, 5)
    elseif data.size[2] == 380 then pyui.set_control_selection(sizeY, 6)
    elseif data.size[2] == 400 then pyui.set_control_selection(sizeY, 7)
    elseif data.size[2] == 420 then pyui.set_control_selection(sizeY, 8)
    elseif data.size[2] == 450 then pyui.set_control_selection(sizeY, 9)
    elseif data.size[2] == 480 then pyui.set_control_selection(sizeY, 10)
    elseif data.size[2] == 500 then pyui.set_control_selection(sizeY, 11)
    elseif data.size[2] == 520 then pyui.set_control_selection(sizeY, 12)
    elseif data.size[2] == 550 then pyui.set_control_selection(sizeY, 13)
    elseif data.size[2] == 600 then pyui.set_control_selection(sizeY, 14)
    elseif data.size[2] == 650 then pyui.set_control_selection(sizeY, 15)
    elseif data.size[2] == 700 then pyui.set_control_selection(sizeY, 16)
    elseif data.size[2] == 750 then pyui.set_control_selection(sizeY, 17)
    end

    dialog:create_group_box({1,4}, "Extra order options")
    
    local label_geleider = dialog:create_label(1, pyloc "Drawer slide")
    local geleider = dialog: create_drop_list(2)
    
    geleider: insert_control_item(pyloc "None")

    local label_tipon= dialog:create_label(3, pyloc "Tip-on set")
    local tipon = dialog: create_drop_list(4)
    tipon: insert_control_item(pyloc "None")
    if data.size[2] <= 300 and data.size[2] >= 270 then
        tipon: insert_control_item("≤10kg")
        if data.tip_on_set == "≤10kg" then pyui.set_control_selection(tipon, 2) end
    end
    if data.size[2] <= 320 and data.size[2] >= 270 then
        tipon: insert_control_item("≤20kg")
        tipon: insert_control_item("10 to 20kg")
        if data.size[2] <= 300 then
            if data.tip_on_set == "≤20kg" then pyui.set_control_selection(tipon, 3) 
            elseif data.tip_on_set == "10 to 20kg" then pyui.set_control_selection(tipon, 4) end
        else
            if data.tip_on_set == "≤20kg" then pyui.set_control_selection(tipon, 2) 
            elseif data.tip_on_set == "10 to 20kg" then pyui.set_control_selection(tipon, 3) end
        end
    end
    if data.size[2] <= 600 and data.size[2] >= 350 then
        tipon: insert_control_item("15 to 40kg")
        if data.tip_on_set == "15 to 40kg" then pyui.set_control_selection(tipon, 2) end
    end
    if data.size[2] <= 750 and data.size[2] >= 450 then
        tipon: insert_control_item("35 to 60kg")
        if data.size[2] <= 600 then
            if data.tip_on_set == "35 to 60kg" then pyui.set_control_selection(tipon, 3) end
        else
            if data.tip_on_set == "35 to 60kg" then pyui.set_control_selection(tipon, 2) end
        end
    end  
    local movento_gemonteerd = dialog:create_check_box(1, pyloc "Fittings mounted")
    if data.gemonteerd == true then pyui.set_control_checked(movento_gemonteerd, true) end
    
    local diepteversteller = dialog:create_check_box(2, pyloc "Movento depth adjusters")
    if data.diepteversteller == true then pyui.set_control_checked(diepteversteller, true) end

    local synst = dialog:create_check_box(3, pyloc "Synchronisation rod")
    if data.synchronisatiestang == true then pyui.set_control_checked(synst,true) end
    
    local opvullijst = dialog:create_check_box(4, pyloc "Filler profile(s)")
    if data.opvullijst_l == true or data.opvullijst_r == true then
        pyui.set_control_checked(opvullijst, true)
        local txt = pyloc "Filler profile "
        if data.opvullijst_l then txt = txt .. "L " end
        if data.opvullijst_l and data.opvullijst_r then txt = txt .. "+ " end
        if data.opvullijst_r then txt = txt .. "R " end
        if data.opvullijst_kleur == "Wit" then
            txt = txt .. "White"
        elseif data.opvullijst_kleur == "Oriongrijs" then
            txt = txt .. "Grey"
        elseif data.opvullijst_kleur == "Zwart" then
            txt = txt .. "Black"
        end
        opvullijst:set_control_text(txt)
    end
    dialog:equalize_column_widths({2,3,4})
    dialog:end_group_box()

    local ok = dialog:create_ok_button({1,2})
    if defined_bc == false then pyui.enable_control(ok, false) end
    local cancel = dialog:create_cancel_button({3,4})

    if data.model == "regulier" then 
        pyui.set_control_selection(modeltype, 1)
        if data.material_main ~= nil then pyui.clear_control_items(hoofdmat) end

        hoofdmat: insert_control_item(pyloc "Melamine black")
        hoofdmat: insert_control_item(pyloc "Melamine white")
        hoofdmat: insert_control_item(pyloc "Melamine anthracite grey")
        hoofdmat: insert_control_item(pyloc "Foil black")
        hoofdmat: insert_control_item(pyloc "Solid oak")
        hoofdmat: insert_control_item(pyloc "Oak veneer")
        hoofdmat: insert_control_item(pyloc "Oak black")
        hoofdmat: insert_control_item(pyloc "Solid beech")
        hoofdmat: insert_control_item(pyloc "Solid walnut")
        
        if data.material_main == "melamine_zwart" then
            pyui.set_control_selection(hoofdmat, 1)
        elseif data.material_main == "melamine_wit" then
            pyui.set_control_selection(hoofdmat, 2)
        elseif data.material_main == "melamine_antraciet" then
            pyui.set_control_selection(hoofdmat, 3)
        elseif data.material_main == "folie_zwart" then
            pyui.set_control_selection(hoofdmat, 4)
        elseif data.material_main == "eiken_massief" then
            pyui.set_control_selection(hoofdmat, 5)
        elseif data.material_main == "eiken_fineer" then
            pyui.set_control_selection(hoofdmat, 6)
        elseif data.material_main == "eiken_zwart" then
            pyui.set_control_selection(hoofdmat, 7)
        elseif data.material_main == "beuken_massief" then
            pyui.set_control_selection(hoofdmat, 8)
        elseif data.material_main == "noten_massief" then
            pyui.set_control_selection(hoofdmat, 9)
        else 
            data.material_main = nil
            pyui.clear_control_items(thickness_main)
            pyui.enable_control(thickness_main, false)  
            pyui.enable_control(ok, false)  
        end
    elseif data.model == "engels" then 
        pyui.set_control_selection(modeltype, 2)
        pyui.enable_control(setback, false)  
        pyui.enable_control(label_setback, false)    

        pyui.clear_control_items(hoofdmat)
        hoofdmat: insert_control_item(pyloc "Solid oak")
        hoofdmat: insert_control_item(pyloc "Oak black")
        hoofdmat: insert_control_item(pyloc "Solid beech")
        hoofdmat: insert_control_item(pyloc "Solid walnut")

        if data.material_main == "eiken_massief" then
            pyui.set_control_selection(hoofdmat, 1)
        elseif data.material_main == "eiken_zwart" then
            pyui.set_control_selection(hoofdmat, 2)
        elseif data.material_main == "beuken_massief" then
            pyui.set_control_selection(hoofdmat, 3)
        elseif data.material_main == "noten_massief" then
            pyui.set_control_selection(hoofdmat, 4)
        else 
            data.material_main = nil
            pyui.clear_control_items(thickness_main)
            pyui.enable_control(thickness_main, false)  
            pyui.enable_control(ok, false)  
        end
        
    elseif data.model == "voortegen" then 
        pyui.set_control_selection(modeltype, 3)
        pyui.enable_control(setback, false) 
        pyui.enable_control(label_setback, false)    

        pyui.clear_control_items(hoofdmat)
        hoofdmat: insert_control_item(pyloc "Melamine black")
        hoofdmat: insert_control_item(pyloc "Melamine white")
        hoofdmat: insert_control_item(pyloc "Melamine anthracite grey")
        hoofdmat: insert_control_item(pyloc "Foil black")
        hoofdmat: insert_control_item(pyloc "Solid oak")
        hoofdmat: insert_control_item(pyloc "Oak veneer")
        hoofdmat: insert_control_item(pyloc "Oak black")
        hoofdmat: insert_control_item(pyloc "Solid beech")
        hoofdmat: insert_control_item(pyloc "Solid walnut")

        if data.material_main == "melamine_zwart" then
            pyui.set_control_selection(hoofdmat, 1)
        elseif data.material_main == "melamine_wit" then
            pyui.set_control_selection(hoofdmat, 2)
        elseif data.material_main == "melamine_antraciet" then
            pyui.set_control_selection(hoofdmat, 3)
        elseif data.material_main == "folie_zwart" then
            pyui.set_control_selection(hoofdmat, 4)
        elseif data.material_main == "eiken_massief" then
            pyui.set_control_selection(hoofdmat, 5)
        elseif data.material_main == "eiken_fineer" then
            pyui.set_control_selection(hoofdmat, 6)
        elseif data.material_main == "eiken_zwart" then
            pyui.set_control_selection(hoofdmat, 7)
        elseif data.material_main == "beuken_massief" then
            pyui.set_control_selection(hoofdmat, 8)
        elseif data.material_main == "noten_massief" then
            pyui.set_control_selection(hoofdmat, 9)
        else 
            data.material_main = nil
            pyui.clear_control_items(thickness_main)
            pyui.enable_control(thickness_main, false)  
            pyui.enable_control(ok, false)  
        end
        
    end

    if data.material_main == "melamine_zwart" or data.material_main == "melamine_wit" then
        thickness_main: insert_control_item("12 mm")
        thickness_main: insert_control_item("16 mm")
        pyui.enable_control(thickness_main, true)
        if data.thickness_main == 12 then pyui.set_control_selection(thickness_main, 1)
        elseif data.thickness_main == 16 then pyui.set_control_selection(thickness_main, 2)
        end
    elseif data.material_main == "folie_zwart" then
        thickness_main: insert_control_item("12 mm")
        pyui.enable_control(thickness_main, false)
    elseif data.material_main ~= nil then
        thickness_main: insert_control_item("13 mm")
        pyui.enable_control(thickness_main, false)
    end

    if data.material_main == "folie_zwart" then
        sizeZ: insert_control_item("55 mm")
        sizeZ: insert_control_item("100 mm")
        sizeZ: insert_control_item("120 mm")
        sizeZ: insert_control_item("140 mm")
        sizeZ: insert_control_item("150 mm")
        sizeZ: insert_control_item("180 mm")
        sizeZ: insert_control_item("260 mm")   
        pyui.enable_control(sizeZ, true)

        if data.size[3] == 55 then pyui.set_control_selection(sizeZ, 1)
        elseif data.size[3] == 100 then pyui.set_control_selection(sizeZ, 2)
        elseif data.size[3] == 120 then pyui.set_control_selection(sizeZ, 3)
        elseif data.size[3] == 140 then pyui.set_control_selection(sizeZ, 4)
        elseif data.size[3] == 150 then pyui.set_control_selection(sizeZ, 5)
        elseif data.size[3] == 180 then pyui.set_control_selection(sizeZ, 6)
        elseif data.size[3] == 260 then pyui.set_control_selection(sizeZ, 7)
        end
    elseif data.material_main == "melamine_zwart" or data.material_main =="melamine_wit" or data.material_main == "melamine_antraciet" then
        sizeZ: insert_control_item("85 mm")
        sizeZ: insert_control_item("100 mm")
        sizeZ: insert_control_item("120 mm")
        sizeZ: insert_control_item("150 mm")
        sizeZ: insert_control_item("180 mm")
        sizeZ: insert_control_item("200 mm")
        sizeZ: insert_control_item("260 mm")   
        pyui.enable_control(sizeZ, true)
        if data.size[3] == 85 then pyui.set_control_selection(sizeZ, 1)
        elseif data.size[3] == 100 then pyui.set_control_selection(sizeZ, 2)
        elseif data.size[3] == 120 then pyui.set_control_selection(sizeZ, 3)
        elseif data.size[3] == 150 then pyui.set_control_selection(sizeZ, 4)
        elseif data.size[3] == 180 then pyui.set_control_selection(sizeZ, 5)
        elseif data.size[3] == 200 then pyui.set_control_selection(sizeZ, 6)
        elseif data.size[3] == 260 then pyui.set_control_selection(sizeZ, 7)
        end
    elseif data.material_main ~= nil then
        sizeZ: insert_control_item("85 mm")
        sizeZ: insert_control_item("100 mm")
        sizeZ: insert_control_item("120 mm")
        sizeZ: insert_control_item("150 mm")
        sizeZ: insert_control_item("180 mm")
        sizeZ: insert_control_item("195 mm")
        sizeZ: insert_control_item("260 mm")   
        pyui.enable_control(sizeZ, true)
        if data.size[3] == 85 then pyui.set_control_selection(sizeZ, 1)
        elseif data.size[3] == 100 then pyui.set_control_selection(sizeZ, 2)
        elseif data.size[3] == 120 then pyui.set_control_selection(sizeZ, 3)
        elseif data.size[3] == 150 then pyui.set_control_selection(sizeZ, 4)
        elseif data.size[3] == 180 then pyui.set_control_selection(sizeZ, 5)
        elseif data.size[3] == 195 then pyui.set_control_selection(sizeZ, 6)
        elseif data.size[3] == 260 then pyui.set_control_selection(sizeZ, 7)
        end
    end

    if data.size[2] <= 600 then
        geleider: insert_control_item("40kg softclose")
        geleider: insert_control_item("40kg tip-on")
        if data.geleider == "40kg softclose" then
            pyui.set_control_selection(geleider, 2)
        end
        if data.geleider == "40kg tip-on" then
            pyui.set_control_selection(geleider, 3)
            pyui.enable_control(tipon, false)
            pyui.enable_control(label_tipon, false)   
            pyui.enable_control(synst, false)
        end
    end
    if data.size[2] >= 450 then
        geleider: insert_control_item("60kg softclose")
        geleider: insert_control_item("60kg tip-on")
        if data.geleider == "60kg softclose" then
            if data.size[2] < 600 then
                pyui.set_control_selection(geleider, 4)
            else
                pyui.set_control_selection(geleider, 2)
            end
        end
        if data.geleider == "60kg tip-on" then
            if data.size[2] < 600 then
                pyui.set_control_selection(geleider, 5)
            else
                pyui.set_control_selection(geleider, 3)
            end
            pyui.enable_control(tipon, false)
            pyui.enable_control(label_tipon, false)   
            pyui.enable_control(synst, false)
        end
    end

    referentie:set_on_change_handler(function(text)
        data.referentie = text
    end)

    modeltype: set_on_change_handler(function(text)
        if text == "Drawer" then
            data.model = "regulier"
            pyui.enable_control(setback, true) 
            pyui.enable_control(label_setback, true)    
            
            pyui.clear_control_items(hoofdmat)
            if data.material_main == nil then hoofdmat: insert_control_item(pyloc "Select material") end

            hoofdmat: insert_control_item(pyloc "Melamine black")
            hoofdmat: insert_control_item(pyloc "Melamine white")
            hoofdmat: insert_control_item(pyloc "Melamine anthracite grey")
            hoofdmat: insert_control_item(pyloc "Foil black")
            hoofdmat: insert_control_item(pyloc "Solid oak")
            hoofdmat: insert_control_item(pyloc "Oak veneer")
            hoofdmat: insert_control_item(pyloc "Oak black")
            hoofdmat: insert_control_item(pyloc "Solid beech")
            hoofdmat: insert_control_item(pyloc "Solid walnut")
            
            if data.material_main == "melamine_zwart" then
                pyui.set_control_selection(hoofdmat, 1)
            elseif data.material_main == "melamine_wit" then
                pyui.set_control_selection(hoofdmat, 2)
            elseif data.material_main == "melamine_antraciet" then
                pyui.set_control_selection(hoofdmat, 3)
            elseif data.material_main == "folie_zwart" then
                pyui.set_control_selection(hoofdmat, 4)
            elseif data.material_main == "eiken_massief" then
                pyui.set_control_selection(hoofdmat, 5)
            elseif data.material_main == "eiken_fineer" then
                pyui.set_control_selection(hoofdmat, 6)
            elseif data.material_main == "eiken_zwart" then
                pyui.set_control_selection(hoofdmat, 7)
            elseif data.material_main == "beuken_massief" then
                pyui.set_control_selection(hoofdmat, 8)
            elseif data.material_main == "noten_massief" then
                pyui.set_control_selection(hoofdmat, 9)
            else 
                data.material_main = nil
                pyui.clear_control_items(thickness_main)
                pyui.enable_control(thickness_main, false)  
                pyui.enable_control(ok, false)  
            end
        elseif text == "Internal drawer C-handle" then
            data.model = "engels"    
            pyui.enable_control(setback, false)     
            pyui.enable_control(label_setback, false)    

            pyui.clear_control_items(hoofdmat)
            if data.material_main == nil or (data.material_main ~= "eiken_massief" and data.material_main ~= "eiken_zwart" and data.material_main ~= "beuken_massief" and data.material_main ~= "noten_massief") then hoofdmat: insert_control_item(pyloc "Select material") end
            
            hoofdmat: insert_control_item(pyloc "Solid oak")
            hoofdmat: insert_control_item(pyloc "Oak black")
            hoofdmat: insert_control_item(pyloc "Solid beech")
            hoofdmat: insert_control_item(pyloc "Solid walnut")

            if data.material_main == "eiken_massief" then
                pyui.set_control_selection(hoofdmat, 1)
            elseif data.material_main == "eiken_zwart" then
                pyui.set_control_selection(hoofdmat, 2)
            elseif data.material_main == "beuken_massief" then
                pyui.set_control_selection(hoofdmat, 3)
            elseif data.material_main == "noten_massief" then
                pyui.set_control_selection(hoofdmat, 4)
            else 
                data.material_main = nil
                pyui.clear_control_items(thickness_main)
                pyui.enable_control(thickness_main, false)  
                pyui.enable_control(ok, false)  
            end
        else
            data.model = "voortegen"
            pyui.enable_control(setback, false) 
            pyui.enable_control(label_setback, false)    

            pyui.clear_control_items(hoofdmat)
            if data.material_main == nil or data.material_main == "noten_massief" then hoofdmat: insert_control_item(pyloc "Select material") end
            
            hoofdmat: insert_control_item(pyloc "Melamine black")
            hoofdmat: insert_control_item(pyloc "Melamine white")
            hoofdmat: insert_control_item(pyloc "Melamine anthracite grey")
            hoofdmat: insert_control_item(pyloc "Foil black")
            hoofdmat: insert_control_item(pyloc "Solid oak")
            hoofdmat: insert_control_item(pyloc "Oak veneer")
            hoofdmat: insert_control_item(pyloc "Oak black")
            hoofdmat: insert_control_item(pyloc "Solid beech")
            hoofdmat: insert_control_item(pyloc "Solid walnut")

            if data.material_main == "melamine_zwart" then
                pyui.set_control_selection(hoofdmat, 1)
            elseif data.material_main == "melamine_wit" then
                pyui.set_control_selection(hoofdmat, 2)
            elseif data.material_main == "melamine_antraciet" then
                pyui.set_control_selection(hoofdmat, 3)
            elseif data.material_main == "folie_zwart" then
                pyui.set_control_selection(hoofdmat, 4)
            elseif data.material_main == "eiken_massief" then
                pyui.set_control_selection(hoofdmat, 5)
            elseif data.material_main == "eiken_fineer" then
                pyui.set_control_selection(hoofdmat, 6)
            elseif data.material_main == "eiken_zwart" then
                pyui.set_control_selection(hoofdmat, 7)
            elseif data.material_main == "beuken_massief" then
                pyui.set_control_selection(hoofdmat, 8)
            elseif data.material_main == "noten_massief" then
                pyui.set_control_selection(hoofdmat, 9)
            else 
                data.material_main = nil
                pyui.clear_control_items(thickness_main)
                pyui.enable_control(thickness_main, false)  
                pyui.enable_control(ok, false)  
            end
        end
    end)

    select_bc_points_button: set_on_click_handler(function()
        p1 = pyux.select_coordinate(false, pyloc "Reference 1: left side internal cabinet front.")
        p2 = pyux.select_coordinate(false, pyloc "Reference 2: right side internal cabinet front.")
        p3 = pyux.select_coordinate(false, pyloc "Reference 3: bottom cabinet.")

        if p1 ~= nil and p2 ~= nil and p3 ~= nil then
            data.origin[1] = p1[1] 
            data.origin[2] = p1[2]
            data.origin[3] = p3[3]
            data.ref_start = p1
            data.ref_end = p2
            
            if p1[1] == p2[1] then
                if p1[2] > p2[2] then
                    data.rot_angle = 90
                else
                    data.rot_angle = 270
                end
                data.size[1] = math.abs(p2[2]-p1[2])
            elseif p1[2] == p2[2] then
                if p1[1] > p2[1] then
                    data.rot_angle = 180
                else
                    data.rot_angle = 0
                end
                data.size[1] = math.abs(p2[1]-p1[1])
            else
                data.size[1] = math.sqrt(math.abs(p2[1]-p1[1])^2+math.abs(p2[2]-p1[2])^2)
                if p1[2] > p2[2] and p1[1] < p2[1] then
                    data.rot_angle = asin((p1[2]-p2[2])/data.size[1])
                elseif p1[2] > p2[2] and p1[1] > p2[1] then
                    data.rot_angle = 180-asin((p1[2]-p2[2])/data.size[1])
                elseif p1[2] < p2[2] and p1[1] < p2[1] then
                    data.rot_angle = asin((p1[2]-p2[2])/data.size[1])
                elseif p1[2] < p2[2] and p1[1] > p2[1] then       
                    data.rot_angle = 180-asin((p1[2]-p2[2])/data.size[1])               
                end
            end
            if data.size[1] < 215 then 
                pyui.alert("The internal cabinet width has to be at least 215 mm.")
                data.size[1] = nil
            elseif data.size[1] < 250 then 
                pyui.alert("Select an internal cabinet of at least 250 mm for an accurate depiction of the drawer.")
            end
            if data.size[1] ~= nil then 
                select_bc_points_button:set_control_text(round(data.size[1], 1).." mm")  
                if data.size[1] < 314 then 
                    pyui.enable_control(tipon, false) 
                    pyui.enable_control(label_tipon, false)     
                elseif not string.match(data.geleider, "tip") then
                    pyui.enable_control(tipon, true) 
                    pyui.enable_control(label_tipon, true)   
                end
            end
        end
        if data.material_bottom ~= nil and data.material_main ~= nil and data.thickness_bottom ~= nil and data.thickness_main~= nil and data.size[1] ~= nil then pyui.enable_control(ok, true)  end
    end)

    -- select_origin_button: set_on_click_handler(function()
    --     p3 = pyux.select_coordinate(false, pyloc "Select the origin of the drawer.")     
    --     if p3 ~= nil then
    --         data.origin = p3
    --         select_origin_button:set_control_text(round(data.origin[1],2) .. "`, " .. round(data.origin[2],2) .. "`, " .. round(data.origin[3],2))  
    --     end       
    -- end)

    manual_input_button: set_on_click_handler(function()
        if data.rot_angle == nil then data.rot_angle = 0 end
        if pyui.run_modal_subdialog(manual_input_dialog, data) == "cancel" then return end
        if data.size[1] ~= nil then
            if data.size[1] < 215 then 
                pyui.alert("The internal cabinet width has to be at least 215 mm.")
                data.size[1] = nil
            elseif data.size[1] < 250 then 
                pyui.alert("Select an internal cabinet of at least 250 mm for an accurate depiction of the drawer.")
            end
            if data.size[1] ~= nil then 
                select_bc_points_button:set_control_text(round(data.size[1], 0).." mm")
                if data.size[1] < 314 then 
                    pyui.enable_control(tipon, false) 
                    pyui.enable_control(label_tipon, false)   
                elseif not string.match(data.geleider, "tip") then
                    pyui.enable_control(tipon, true) 
                    pyui.enable_control(label_tipon, true)   
                end
            end
        end

        if data.material_bottom ~= nil and data.material_main ~= nil and data.thickness_bottom ~= nil and data.thickness_main~= nil and data.size[1] ~= nil then pyui.enable_control(ok, true)  end 
    end)

    hoofdmat: set_on_change_handler(function(text)
        if text == "Melamine black" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("12 mm")
            thickness_main: insert_control_item("16 mm")
            if data.thickness_main == 16 then pyui.set_control_selection(thickness_main, 2) else data.thickness_main = 12 end
            pyui.enable_control(thickness_main, true)
            data.material_main = "melamine_zwart"
            data.mat_massief = false
            if data.model == "regulier" or data.model == "voortegen" then
                pyui.clear_control_items(sizeZ)
                sizeZ: insert_control_item("85 mm")
                sizeZ: insert_control_item("100 mm")
                sizeZ: insert_control_item("120 mm")
                sizeZ: insert_control_item("150 mm")
                sizeZ: insert_control_item("180 mm")
                sizeZ: insert_control_item("200 mm")
                sizeZ: insert_control_item("260 mm")  
                if data.size[3] == 85 then
                    pyui.set_control_selection(sizeZ, 1)
                elseif data.size[3] == 100 then
                    pyui.set_control_selection(sizeZ, 2)
                elseif data.size[3] == 120 then
                    pyui.set_control_selection(sizeZ, 3)
                elseif data.size[3] == 150 then
                    pyui.set_control_selection(sizeZ, 4)
                elseif data.size[3] == 180 then
                    pyui.set_control_selection(sizeZ, 5)
                elseif data.size[3] == 200 then
                    pyui.set_control_selection(sizeZ, 6)
                elseif data.size[3] == 260 then
                    pyui.set_control_selection(sizeZ, 7)
                else
                    data.size[3] = 85
                end  
            end
            pyui.enable_control(sizeZ, true)
        elseif text == "Melamine white" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("12 mm")
            thickness_main: insert_control_item("16 mm")
            if data.thickness_main == 16 then pyui.set_control_selection(thickness_main, 2) else data.thickness_main = 12 end
            pyui.enable_control(thickness_main, true)
            data.thickness_main = 12
            data.material_main = "melamine_wit"
            data.mat_massief = false
            if data.model == "regulier" or data.model == "voortegen" then
                pyui.clear_control_items(sizeZ)
                sizeZ: insert_control_item("85 mm")
                sizeZ: insert_control_item("100 mm")
                sizeZ: insert_control_item("120 mm")
                sizeZ: insert_control_item("150 mm")
                sizeZ: insert_control_item("180 mm")
                sizeZ: insert_control_item("200 mm")
                sizeZ: insert_control_item("260 mm")   
                if data.size[3] == 85 then
                    pyui.set_control_selection(sizeZ, 1)
                elseif data.size[3] == 100 then
                    pyui.set_control_selection(sizeZ, 2)
                elseif data.size[3] == 120 then
                    pyui.set_control_selection(sizeZ, 3)
                elseif data.size[3] == 150 then
                    pyui.set_control_selection(sizeZ, 4)
                elseif data.size[3] == 180 then
                    pyui.set_control_selection(sizeZ, 5)
                elseif data.size[3] == 200 then
                    pyui.set_control_selection(sizeZ, 6)
                elseif data.size[3] == 260 then
                    pyui.set_control_selection(sizeZ, 7)
                else
                    data.size[3] = 85
                end 
            end
            pyui.enable_control(sizeZ, true)
        elseif text == "Melamine anthracite grey" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("12 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 12
            data.material_main = "melamine_antraciet"
            data.mat_massief = false
            if data.model == "regulier" or data.model == "voortegen" then
                pyui.clear_control_items(sizeZ)
                sizeZ: insert_control_item("85 mm")
                sizeZ: insert_control_item("100 mm")
                sizeZ: insert_control_item("120 mm")
                sizeZ: insert_control_item("150 mm")
                sizeZ: insert_control_item("180 mm")
                sizeZ: insert_control_item("200 mm")
                sizeZ: insert_control_item("260 mm")  
                if data.size[3] == 85 then
                    pyui.set_control_selection(sizeZ, 1)
                elseif data.size[3] == 100 then
                    pyui.set_control_selection(sizeZ, 2)
                elseif data.size[3] == 120 then
                    pyui.set_control_selection(sizeZ, 3)
                elseif data.size[3] == 150 then
                    pyui.set_control_selection(sizeZ, 4)
                elseif data.size[3] == 180 then
                    pyui.set_control_selection(sizeZ, 5)
                elseif data.size[3] == 200 then
                    pyui.set_control_selection(sizeZ, 6)
                elseif data.size[3] == 260 then
                    pyui.set_control_selection(sizeZ, 7)
                else
                    data.size[3] = 85
                end 
            end
            pyui.enable_control(sizeZ, true)
        elseif text == "Foil black" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("12 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 12
            data.material_main = "folie_zwart"
            data.mat_massief = false
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("55 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("140 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("260 mm")  
            
            if data.size[3] == 55 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 140 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 55
            end
            pyui.enable_control(sizeZ, true)
        elseif text == "Solid oak" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("13 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 13
            data.material_main = "eiken_massief"
            data.mat_massief = true
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("85 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("195 mm")
            sizeZ: insert_control_item("260 mm")   
            if data.size[3] == 85 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 195 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 85
            end 
            pyui.enable_control(sizeZ, true)
        elseif text == "Oak veneer" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("13 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 13
            data.material_main = "eiken_fineer"
            data.mat_massief = true
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("85 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("195 mm")
            sizeZ: insert_control_item("260 mm")  
            if data.size[3] == 85 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 195 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 85
            end  
            pyui.enable_control(sizeZ, true)
        elseif text == "Oak black" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("13 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 13
            data.material_main = "eiken_zwart"
            data.mat_massief = true
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("85 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("195 mm")
            sizeZ: insert_control_item("260 mm")  
            if data.size[3] == 85 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 195 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 85
            end  
            pyui.enable_control(sizeZ, true)
        elseif text == "Solid beech" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("13 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 13
            data.material_main = "beuken_massief"
            data.mat_massief = true
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("85 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("195 mm")
            sizeZ: insert_control_item("260 mm")
            if data.size[3] == 85 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 195 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 85
            end    
            pyui.enable_control(sizeZ, true)
        elseif text == "Solid walnut" then
            pyui.clear_control_items(thickness_main)
            thickness_main: insert_control_item("13 mm")
            pyui.enable_control(thickness_main, false)
            data.thickness_main = 13
            data.material_main = "noten_massief"
            data.mat_massief = true
            pyui.clear_control_items(sizeZ)
            sizeZ: insert_control_item("85 mm")
            sizeZ: insert_control_item("100 mm")
            sizeZ: insert_control_item("120 mm")
            sizeZ: insert_control_item("150 mm")
            sizeZ: insert_control_item("180 mm")
            sizeZ: insert_control_item("195 mm")
            sizeZ: insert_control_item("260 mm")   
            if data.size[3] == 85 then
                pyui.set_control_selection(sizeZ, 1)
            elseif data.size[3] == 100 then
                pyui.set_control_selection(sizeZ, 2)
            elseif data.size[3] == 120 then
                pyui.set_control_selection(sizeZ, 3)
            elseif data.size[3] == 150 then
                pyui.set_control_selection(sizeZ, 4)
            elseif data.size[3] == 180 then
                pyui.set_control_selection(sizeZ, 5)
            elseif data.size[3] == 195 then
                pyui.set_control_selection(sizeZ, 6)
            elseif data.size[3] == 260 then
                pyui.set_control_selection(sizeZ, 7)
            else
                data.size[3] = 85
            end 
            pyui.enable_control(sizeZ, true)
        end
        if data.material_bottom ~= nil and data.material_main ~= nil and data.thickness_bottom ~= nil and data.thickness_main~= nil and data.size[1] ~= nil then pyui.enable_control(ok, true)  end 
    end)  

    thickness_main: set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        data.thickness_main = pyui.parse_length(txt)
    end)

    bottommat: set_on_change_handler(function(text)
        if text == "Black" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("4 mm")
            thickness_bottom: insert_control_item("10 mm")
            pyui.enable_control(thickness_bottom, true)
            if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
            elseif data.thickness_bottom == 10 then pyui.set_control_selection(thickness_bottom, 2)
            else data.thickness_bottom = 4
            end
            data.material_bottom = "melamine_zwart"
        elseif text == "White" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("4 mm")
            thickness_bottom: insert_control_item("10 mm")
            pyui.enable_control(thickness_bottom, true)
            if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
            elseif data.thickness_bottom == 10 then pyui.set_control_selection(thickness_bottom, 2)
            else data.thickness_bottom = 4
            end
            data.material_bottom = "melamine_wit"
        elseif text == "Anthracite grey" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("10 mm")
            pyui.enable_control(thickness_bottom, false)
            data.thickness_bottom = 10
            data.material_bottom = "melamine_antraciet"
        elseif text == "Oak" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("9 mm")
            pyui.enable_control(thickness_bottom, false)
            data.thickness_bottom = 9
            data.material_bottom = "eiken_massief"
        elseif text == "Beech" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("4 mm")
            thickness_bottom: insert_control_item("9 mm")
            pyui.enable_control(thickness_bottom, true)
            if data.thickness_bottom == 4 then pyui.set_control_selection(thickness_bottom, 1)
            elseif data.thickness_bottom == 9 then pyui.set_control_selection(thickness_bottom, 2)
            else data.thickness_bottom = 4
            end
            data.material_bottom = "beuken_massief"
        elseif text == "Walnut" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("10 mm")
            pyui.enable_control(thickness_bottom, false)
            data.thickness_bottom = 10
            data.material_bottom = "noten_massief"
        elseif text == "Anti-slip" then
            pyui.clear_control_items(thickness_bottom)
            thickness_bottom: insert_control_item("11.2 mm")
            pyui.enable_control(thickness_bottom, false)
            data.thickness_bottom = 11.2
            data.material_bottom = "anti_slip"
        end
        if data.material_bottom ~= nil and data.material_main ~= nil and data.thickness_bottom ~= nil and data.thickness_main~= nil and data.size[1] ~= nil then pyui.enable_control(ok, true)  end 
    end)
    
    thickness_bottom: set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        data.thickness_bottom = pyui.parse_length(txt)
    end)

    sizeY:set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        data.size[2] = pyui.parse_length(txt)

        pyui.clear_control_items(geleider)
        geleider: insert_control_item(pyloc "None")
        -- data.geleider = "None"
        if data.size[2] <= 600 then
            geleider: insert_control_item("40kg softclose")
            geleider: insert_control_item("40kg tip-on")
            if data.geleider == "40kg softclose" then
                pyui.set_control_selection(geleider, 2)
            end
            if data.geleider == "40kg tip-on" then
                pyui.set_control_selection(geleider, 3)
            end
        end
        if data.size[2] >= 450 then
            geleider: insert_control_item("60kg softclose")
            geleider: insert_control_item("60kg tip-on")
            if data.geleider == "60kg softclose" then
                if data.size[2] < 600 then
                    pyui.set_control_selection(geleider, 4)
                else
                    pyui.set_control_selection(geleider, 2)
                end
            end
            if data.geleider == "60kg tip-on" then
                if data.size[2] < 600 then
                    pyui.set_control_selection(geleider, 5)
                else
                    pyui.set_control_selection(geleider, 3)
                end
            end
        end

        pyui.clear_control_items(tipon)
        tipon: insert_control_item(pyloc "None")
        if data.size[2] <= 300 and data.size[2] >= 270 then
            tipon: insert_control_item("≤10kg")
        end
        if data.size[2] <= 320 and data.size[2] >= 270 then
            tipon: insert_control_item("≤20kg")
            tipon: insert_control_item("10 to 20kg")
        end
        if data.size[2] <= 600 and data.size[2] >= 350 then
            tipon: insert_control_item("15 to 40kg")
        end
        if data.size[2] <= 750 and data.size[2] >= 450 then
            tipon: insert_control_item("35 to 60kg")
        end
    end)

    diepteversteller:set_on_click_handler(function(new_state)
        if new_state then
            data.diepteversteller = true
        else
            data.diepteversteller = false
        end
    end)

    geleider:set_on_change_handler(function(text)
        data.geleider = text
        if string.match(data.geleider, "tip") then
            pyui.enable_control(tipon, false)
            pyui.enable_control(label_tipon, false)   
            pyui.enable_control(synst, false)
        else
            if data.size[1] ~= nil then
                if data.size[1] < 314 then 
                    pyui.enable_control(tipon, false) 
                    pyui.enable_control(label_tipon, false)   
                else 
                    pyui.enable_control(tipon, true) 
                    pyui.enable_control(label_tipon, true)   
                end
            else
                pyui.enable_control(tipon, true)
                pyui.enable_control(label_tipon, true)   
            end
            pyui.enable_control(synst, true)
        end
    end)

    sizeZ:set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        data.size[3] = pyui.parse_length(txt)
    end)

    setback:set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        if pyui.parse_length(txt) ~= "" then
            data.setback = pyui.parse_length(txt)
        end
    end)

    synst:set_on_click_handler(function(new_state)
        if new_state then
            data.synchronisatiestang = true
        else
            data.synchronisatiestang = false
        end
    end)

    opvullijst:set_on_click_handler(function(new_state)
        if new_state then
            data.opvullijst = true
            if pyui.run_modal_subdialog(opvullijstkeuze_dialog, data) == "cancel" then 
                data.opvullijst = false 
                pyui.set_control_checked(opvullijst, false) 
                opvullijst:set_control_text(pyloc "Filler profile(s)")
            else 
                local txt = pyloc "Filler profile "
                if data.opvullijst_l then txt = txt .. "L " end
                if data.opvullijst_l and data.opvullijst_r then txt = txt .. "+ " end
                if data.opvullijst_r then txt = txt .. "R " end
                if data.opvullijst_kleur == "Wit" then opvullijst_kleur = "White"
                elseif data.opvullijst_kleur == "Oriongrijs" then opvullijst_kleur = "Grey"
                elseif data.opvullijst_kleur == "Zwart" then opvullijst_kleur = "Black"
                end
                txt = txt .. opvullijst_kleur 
                opvullijst:set_control_text(txt)
            end
        else
            data.opvullijst = false
            opvullijst:set_control_text(pyloc "Filler profile(s)")
            data.opvullijst_l = false
            data.opvullijst_r = false
        end
    end)

    movento_gemonteerd:set_on_click_handler(function(new_state)
        if new_state then
            data.gemonteerd = true
        else
            data.gemonteerd = false
        end
    end)

    tipon:set_on_change_handler(function(text)
        data.tip_on_set = text
    end)
end

function manual_input_dialog(dialog, data)
    dialog:set_window_title(pyloc "Manual input")
    local label1 = dialog:create_label(1, pyloc "Internal cabinet width in mm")
    local binnencorpus = dialog:create_text_box(2)
    if data.size[1] ~= nil then 
        binnencorpus:set_control_text(round(data.size[1], 2))
    end
    data.ref_end = nil
    local label2 = dialog:create_label(1, pyloc "Origin (comma separated)")
    local org = round(data.origin[1], 2)..", " ..round(data.origin[2], 2)..", "..round(data.origin[3], 2)
    local origin = dialog:create_text_box(2, org)
    local label3 = dialog:create_label(1, pyloc "Rotation in degrees (from origin)")
    local rotation = dialog:create_text_box(2, round(data.rot_angle,1))
    local ok = dialog:create_ok_button(1)
    local cancel = dialog:create_cancel_button(2)
    dialog:equalize_column_widths({1,2})

    binnencorpus: set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.]", "")
        txt = text:gsub("[,]", ".")
        if pyui.parse_length(txt) ~= "" then
            data.size[1] = pyui.parse_length(txt)
            
            -- if data.rot_angle == 0 then
            --     data.ref_end = {data.origin[1]+data.size[1],data.origin[2],data.origin[3]} -------------------------------------------------------------------------------------------------------------
            -- else
            --     -- data.size[1] = math.sqrt(math.abs(p2[1]-p1[1])^2+math.abs(p2[2]-p1[2])^2)
            --     -- if p1[2] > p2[2] and p1[1] < p2[1] then
            --     --     data.rot_angle = asin((p1[2]-p2[2])/data.size[1])
            --     -- elseif p1[2] > p2[2] and p1[1] > p2[1] then
            --     --     data.rot_angle = 180-asin((p1[2]-p2[2])/data.size[1])
            --     -- elseif p1[2] < p2[2] and p1[1] < p2[1] then
            --     --     data.rot_angle = asin((p1[2]-p2[2])/data.size[1])
            --     -- elseif p1[2] < p2[2] and p1[1] > p2[1] then       
            --     --     data.rot_angle = 180-asin((p1[2]-p2[2])/data.size[1])               
            --     -- end
            --     --pyui.alert(data.rot_angle)
            --     --pyui.alert(cos(data.rot_angle))
            --     -- pyui.alert(data.origin[1])
            --     -- pyui.alert(data.size[1]*cos(180-data.rot_angle))
            --     data.ref_end = {data.origin[1]-data.size[1]*cos(-data.rot_angle),data.origin[2]-data.size[1]*sin(-data.rot_angle),data.origin[3]}
            -- end
        end
    end)

    origin: set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.,-]", "")
        if pyui.parse_length(txt) ~= "" then
            local o = {}
            local entrycounter = 0
            for str in string.gmatch(txt, "([^,]+)") do
                table.insert(o, str)
                entrycounter = entrycounter+1
            end
            if entrycounter == 0 then 
                data.origin = {0,0,0}
            elseif entrycounter == 1 then
                data.origin[1] = o[1]
                data.origin[2] = 0
                data.origin[3] = 0
            elseif entrycounter == 2 then
                data.origin[1] = o[1]
                data.origin[2] = o[2]
                data.origin[3] = 0
            else
                if entrycounter>3 then pyui.alert("Please check your input. Plugin encountered more values than expected.") end
                data.origin[1] = o[1]
                data.origin[2] = o[2]
                data.origin[3] = o[3]
            end

            -- if data.size[1] ~=  nil then
            --     if data.rot_angle == 0 then
            --         data.ref_end = {data.origin[1]+data.size[1],data.origin[2],data.origin[3]} -------------------------------------------------------------------------------------------------------------
            --     else
            --         local rotation = 360-data.rot_angle
            --         if rotation <90 then
            --             data.ref_end = {data.origin[1]+abs(data.size[1]*cos(-rotation)),data.origin[2]+abs(data.size[1]*sin(-rotation)),data.origin[3]}
            --         elseif rotation <180 then
            --             data.ref_end = {data.origin[1]-abs(data.size[1]*cos(-rotation)),data.origin[2]+abs(data.size[1]*sin(-rotation)),data.origin[3]}
            --         elseif rotation <270 then
            --             data.ref_end = {data.origin[1]-abs(data.size[1]*cos(-rotation)),data.origin[2]-abs(data.size[1]*sin(-rotation)),data.origin[3]}
            --         else
            --             data.ref_end = {data.origin[1]+abs(data.size[1]*cos(-rotation)),data.origin[2]-abs(data.size[1]*sin(-rotation)),data.origin[3]}
            --         end
            --     end
            -- end
        end
    end)

    rotation: set_on_change_handler(function(text)
        local txt = text:gsub("[^0123456789.-]", "")
        txt = text:gsub("[,]", ".")
        if pyui.parse_length(txt) == "-" then pyui.alert("!") end
        if pyui.parse_length(txt) ~= "" then
            data.rot_angle = pyui.parse_length(txt)
            -- if data.size[1] ~=  nil then
            --     if data.rot_angle == 0 then
            --         data.ref_end = {data.origin[1]+data.size[1],data.origin[2],data.origin[3]} -------------------------------------------------------------------------------------------------------------
            --     else
            --         if data.rot_angle <90 then
            --             data.ref_end = {data.origin[1]+abs(data.size[1]*cos(-data.rot_angle)),data.origin[2]+abs(data.size[1]*sin(-data.rot_angle)),data.origin[3]}
            --         elseif data.rot_angle <180 then
            --             data.ref_end = {data.origin[1]-abs(data.size[1]*cos(-data.rot_angle)),data.origin[2]+abs(data.size[1]*sin(-data.rot_angle)),data.origin[3]}
            --         elseif data.rot_angle <270 then
            --             data.ref_end = {data.origin[1]-abs(data.size[1]*cos(-data.rot_angle)),data.origin[2]-abs(data.size[1]*sin(-data.rot_angle)),data.origin[3]}
            --         else
            --             data.ref_end = {data.origin[1]+abs(data.size[1]*cos(-data.rot_angle)),data.origin[2]-abs(data.size[1]*sin(-data.rot_angle)),data.origin[3]}
            --         end
            --         --data.ref_end = {data.origin[1]-data.size[1]*cos(-data.rot_angle),data.origin[2]-data.size[1]*sin(-data.rot_angle),data.origin[3]}
            --     end
            -- end
        end
    end)

end

function opvullijstkeuze_dialog(dialog, data)
    dialog:set_window_title(pyloc "Filler profile(s)")

    local links = dialog:create_check_box(1, pyloc "Left")
    local rechts = dialog:create_check_box(2, pyloc "Right")

    local kleur_label = dialog:create_label(1, pyloc "Colour")
    local kleur = dialog: create_drop_list(2)
    
    kleur: insert_control_item(pyloc "White")
    kleur: insert_control_item(pyloc "Oriongrey")
    kleur: insert_control_item(pyloc "Black")

    if data.opvullijst_kleur == "Wit" then
        pyui.set_control_selection(kleur, 1)
    elseif data.opvullijst_kleur == "Oriongrijs" then
        pyui.set_control_selection(kleur, 2)
    elseif data.opvullijst_kleur == "Zwart" then
        pyui.set_control_selection(kleur, 3)
    end

    local ok = dialog:create_ok_button(1)
    local cancel = dialog:create_cancel_button(2)

    links:set_on_click_handler(function(new_state)
        if new_state then
            data.opvullijst_l = true
        else
            data.opvullijst_l = false
        end
    end)

    rechts:set_on_click_handler(function(new_state)
        if new_state then
            data.opvullijst_r = true
        else
            data.opvullijst_r = false
        end
    end)

    kleur:set_on_change_handler(function(text)
        if text == "White" then data.opvullijst_kleur = "Wit"
        elseif text == "Oriongrey" then data.opvullijst_kleur = "Oriongrijs"
        elseif text == "Black" then data.opvullijst_kleur = "Zwart"
        end
    end)
end

--------------------------------------------    START REGULIER
function create_lade_regulier(data, material_list)

    local bottommat = nil
    local mainmat = nil
    local lijstkleur= nil
    
    for i,v in ipairs(material_list) do
        if material_list[i][1] == data.material_bottom then
            bottommat = material_list[i][2]
        end
        if material_list[i][1] == data.material_main then
            mainmat = material_list[i][2]
        end
        if material_list[i][1] == data.opvullijst_kleur then
            lijstkleur = material_list[i][2]
        end
    end
    
    local lade_breedte = data.size[1]-(21-data.thickness_main)*2
    local lade_diepte = data.size[2]-10
    local lade_hoogte = data.size[3]

    local complete_width = data.size[1]

    if data.opvullijst_l and data.opvullijst_r then
        lade_breedte = lade_breedte - 50
        data.size[1] = data.size[1] - 50
    elseif data.opvullijst_l or data.opvullijst_r then
        lade_breedte = lade_breedte - 25
        data.size[1] = data.size[1] - 25
    end

    --bodem
    bodem = pytha.create_block(lade_breedte-10, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom, {(21-data.thickness_main)+5, data.thickness_main-5, 13.15}, {name = "Bodem"})
    lade = pytha.create_group(bodem, {name = "KIMA drawer"})
    pytha.set_element_attributes(bodem, { material_name = bottommat })

    --voor
    if data.mat_massief == true then
        voor = pytha.create_block(lade_breedte-2*data.thickness_main, data.thickness_main, lade_hoogte-2, {(21-data.thickness_main)+data.thickness_main, 1, 0},{name = "Front"}) 
    else
        voor = pytha.create_block(lade_breedte-2*data.thickness_main, data.thickness_main, lade_hoogte, {(21-data.thickness_main)+data.thickness_main, 1, 0},{name = "Front"}) 
    end

    if data.size[1] >= 250 then
        snedehandle = pyux.get_library_handle("library", "KIMA", "snede")
        snede_v = pytha.import_pyo(snedehandle, {data.size[1]/2, data.thickness_main+1, 0},{},{width = lade_breedte})
        voor = pytha.boole_part_difference(voor,snede_v)
    end    
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    voor = pytha.boole_part_difference(voor, temp) 
    pytha.set_element_attributes(voor, { material_name = mainmat })
    pytha.set_element_group(voor, lade)

    --links
    links = pytha.create_block(data.thickness_main, lade_diepte, lade_hoogte, {(21-data.thickness_main), 0, 0}, {name = "Linker zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    links = pytha.boole_part_difference(links, temp) 
    pytha.set_element_attributes(links, { material_name = mainmat })
    pytha.set_element_group(links, lade)

    --rechts
    rechts = pytha.create_block(data.thickness_main, lade_diepte, lade_hoogte, {data.size[1]-21, 0, 0}, {name = "Rechter zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    rechts = pytha.boole_part_difference(rechts, temp) 
    pytha.set_element_attributes(rechts, { material_name = mainmat })
    pytha.set_element_group(rechts, lade)

    --achter
    if data.mat_massief == true then
        achter = pytha.create_block(lade_breedte-data.thickness_main*2, data.thickness_main,  lade_hoogte-2, {(21-data.thickness_main)+data.thickness_main, lade_diepte-data.thickness_main-1, 0}, {name = "Achterwand"})
    else
        achter = pytha.create_block(lade_breedte-data.thickness_main*2, data.thickness_main,  lade_hoogte, {(21-data.thickness_main)+data.thickness_main, lade_diepte-data.thickness_main-1, 0}, {name = "Achterwand"})
    end
    snedehandle = pyux.get_library_handle("library", "KIMA", "snede")
    if data.size[1] >= 250 then
        snede = pytha.import_pyo(snedehandle, {data.size[1]/2, lade_diepte+20-data.thickness_main-1, 0},{},{width = lade_breedte})
        achter=pytha.boole_part_difference(achter,snede)
    end

    pytha.set_element_attributes(achter, { material_name = mainmat })
    pytha.set_element_group(achter, lade)

    --geleider
    if lade_diepte <= 270 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_250270")
    elseif lade_diepte <= 350 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_300350")
    elseif lade_diepte <= 520 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_380520")
    else
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_550600")
    end

    geleider = pytha.import_pyo(filehandle, {0, 0, -13.93}, {}, {g_b = data.size[1], g_d = data.size[2]})
    middelen = pytha.create_group(geleider, {name = "blum movento"})

    --FRONTBORINGEN
    if data.setback == nil then data.setback = 0 end
    filehandle_hole = pyux.get_library_handle("library", "KIMA", "hole")
    front_boring_links = pytha.import_pyo(filehandle_hole, {15, -data.setback, lade_hoogte/2})
    pytha.set_element_group(front_boring_links, lade)
    front_boring_rechts = pytha.import_pyo(filehandle_hole, {data.size[1]-15, -data.setback, lade_hoogte/2})
    pytha.set_element_group(front_boring_rechts, lade)

    pytha.move_element(lade, {0, 0, 1.42})
    ladegroep = pytha.create_group({lade, middelen}, {name= data.referentie})
    
    --OPVULLIJST(EN)
    if data.opvullijst_l or data.opvullijst_r then
        opvullijsten = pytha.create_group({}, {name= "Opvullijst(en)"})
        if data.opvullijst_l then
            opvullade_links = pytha.create_block(25, data.size[2], 50, {-25, 2, -13.93}, {name = "Opvullijst links"})
            pytha.set_element_attributes(opvullade_links, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_links, opvullijsten)
        end 
        if data.opvullijst_r then

            if data.opvullijst_l then
                opvullade_rechts = pytha.create_block(25, data.size[2], 50, {complete_width-50, 2, -13.93}, {name = "Opvullijst rechts"})
            else
                opvullade_rechts = pytha.create_block(25, data.size[2], 50, {complete_width-25, 2, -13.93}, {name = "Opvullijst rechts"})
            end
            pytha.set_element_attributes(opvullade_rechts, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_rechts, opvullijsten)
        end
        pytha.set_element_group(opvullijsten, ladegroep)
    end

    if data.ref_end == nil then
        pytha.create_element_ref_point(ladegroep, {complete_width, -5, -13.89}) 
    end
    
    if data.opvullijst_l then
        pytha.move_element(ladegroep, {data.origin[1]+25, data.origin[2], data.origin[3] + 13.89})
    else
        pytha.move_element(ladegroep, {data.origin[1], data.origin[2], data.origin[3] + 13.89})
    end

    pytha.rotate_element(ladegroep, data.origin, {0, 0, 100}, -data.rot_angle)

    pytha.create_element_ref_point(ladegroep, data.origin) 
    if data.rot_angle ~= nil and data.rot_angle ~= 0 and data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.ref_end[1] - (data.ref_start[1] - data.origin[1]), data.ref_end[2] - (data.ref_start[2] - data.origin[2]), data.origin[3]}) 
    elseif data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.origin[1] + complete_width, data.origin[2], data.origin[3]}) 
    end

    data.corrected_width = data.size[1]
    data.size[1] = complete_width

    pytha.set_element_history(bodem, data, "lade_history_prt")
    pytha.set_element_history(ladegroep, data, "lade_history")
end

--------------------------------------------    END REGULIER
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------    START ENGELS
function create_lade_engels(data, material_list)
    local bottommat = nil
    local mainmat = nil
    local lijstkleur= nil

    for i,v in ipairs(material_list) do
        if material_list[i][1] == data.material_bottom then
            bottommat = material_list[i][2]
        end
        if material_list[i][1] == data.material_main then
            mainmat = material_list[i][2]
        end
        if material_list[i][1] == data.opvullijst_kleur then
            lijstkleur = material_list[i][2]
        end
      end

    local lade_breedte = data.size[1] - (21-data.thickness_main) * 2
    local lade_diepte = data.size[2] - 10 + data.thickness_main
    local lade_hoogte = data.size[3]
    
    local complete_width = data.size[1]

    if data.opvullijst_l and data.opvullijst_r then
        lade_breedte = lade_breedte - 50
        data.size[1] = data.size[1] - 50
    elseif data.opvullijst_l or data.opvullijst_r then
        lade_breedte = lade_breedte - 25
        data.size[1] = data.size[1] - 25
    end

    --bodem
    bodem = pytha.create_block(lade_breedte-(21-data.thickness_main), lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom, {(21-data.thickness_main)+5, data.thickness_main-5, 13.15}, {name = "Bodem"})
    lade = pytha.create_group(bodem, {name = "KIMA internal drawer C-handle"})
    pytha.set_element_attributes(bodem, { material_name = bottommat })

    --voor
    voor = pytha.create_block(lade_breedte+4, data.thickness_main, lade_hoogte+16, {(21-data.thickness_main)-2, 0, -13},{name = "Front"}) 
    handhandle = pyux.get_library_handle("library", "KIMA", "handvat")
    if data.size[1] >= 200 then
        handvat = pytha.import_pyo(handhandle, {data.size[1]/2, data.thickness_main, lade_hoogte+3})
        achter=pytha.boole_part_difference(voor, handvat)
    end     
        temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
        voor = pytha.boole_part_difference(voor, temp)
    
    pytha.set_element_attributes(voor, { material_name = mainmat })
    pytha.set_element_group(voor, lade)

    --links
    links = pytha.create_block(data.thickness_main, lade_diepte-data.thickness_main, lade_hoogte, {(21-data.thickness_main), data.thickness_main, 0}, {name = "Linker zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    links = pytha.boole_part_difference(links, temp) 
    pytha.set_element_attributes(links, { material_name = mainmat })
    pytha.set_element_group(links, lade)

    --rechts
    rechts = pytha.create_block(data.thickness_main, lade_diepte-data.thickness_main, lade_hoogte, {lade_breedte-data.thickness_main+(21-data.thickness_main), data.thickness_main, 0}, {name = "Rechter zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    rechts = pytha.boole_part_difference(rechts, temp) 
    pytha.set_element_attributes(rechts, { material_name = mainmat })
    pytha.set_element_group(rechts, lade)

    --achter
    achter = pytha.create_block(lade_breedte-data.thickness_main*2, data.thickness_main, lade_hoogte-2, {data.thickness_main+(21-data.thickness_main), lade_diepte-data.thickness_main-.5, 0}, {name = "Achterwand"})
    snedehandle = pyux.get_library_handle("library", "KIMA", "snede")
    if data.size[1] >= 250 then
        snede = pytha.import_pyo(snedehandle, {data.size[1]/2, lade_diepte+19.5-data.thickness_main, 0}, {}, {width = lade_breedte})
        achter=pytha.boole_part_difference(achter, snede)
    end

    pytha.set_element_attributes(achter, { material_name = mainmat })
    pytha.set_element_group(achter, lade)
    

    --geleider
    if lade_diepte <= 270 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_250270")
    elseif lade_diepte <= 350 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_300350")
    elseif lade_diepte <= 520 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_380520")
    else
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_550600")
    end
    geleider = pytha.import_pyo(filehandle, {0, 22, -13.93}, {}, {g_b = data.size[1], g_d = data.size[2]-10}) 
    middelen = pytha.create_group(geleider, {name="blum movento"})
 
    pytha.move_element(lade, {0,0,1.42})

    ladegroep = pytha.create_group({lade, middelen}, {name = data.referentie})

    --OPVULLIJST(EN)
    if data.opvullijst_l or data.opvullijst_r then
        opvullijsten = pytha.create_group({}, {name= "Opvullijst(en)"})
        if data.opvullijst_l then
            opvullade_links = pytha.create_block(25, data.size[2]-10, 50, {-25, 22, -13.93}, {name = "Opvullijst links"})
            pytha.set_element_attributes(opvullade_links, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_links, opvullijsten)
        end 
        if data.opvullijst_r then
            if data.opvullijst_l then
                opvullade_rechts = pytha.create_block(25, data.size[2]-10, 50, {complete_width-50, 22, -13.93}, {name = "Opvullijst rechts"})
            else
                opvullade_rechts = pytha.create_block(25, data.size[2]-10, 50, {complete_width-25, 22, -13.93}, {name = "Opvullijst rechts"})
            end
            pytha.set_element_attributes(opvullade_rechts, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_rechts, opvullijsten)
        end
        pytha.set_element_group(opvullijsten, ladegroep)
    end

    if data.ref_end == nil then
        pytha.create_element_ref_point(ladegroep, {complete_width, -5, -13.89}) 
    end

    if data.opvullijst_l then
        pytha.move_element(ladegroep, {data.origin[1]+25, data.origin[2]+5, data.origin[3]+13.89})
    else
        pytha.move_element(ladegroep, {data.origin[1], data.origin[2]+5, data.origin[3]+13.89})
    end

    pytha.rotate_element(ladegroep, data.origin, {0,0,100}, -data.rot_angle)

    pytha.create_element_ref_point(ladegroep, data.origin) 
    if data.rot_angle ~= nil and data.rot_angle ~= 0 and data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.ref_end[1]-(data.ref_start[1]-data.origin[1]), data.ref_end[2]-(data.ref_start[2]-data.origin[2]), data.origin[3]}) 
    elseif data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.origin[1]+complete_width, data.origin[2], data.origin[3]}) 
    end

    data.corrected_width = data.size[1]
    data.size[1] = complete_width

    pytha.set_element_history(bodem, data, "lade_history_prt")
    pytha.set_element_history(ladegroep, data, "lade_history")
end
--------------------------------------------    END ENGELS
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------    START VOORTEGEN
function create_lade_voortegen(data, material_list)
    local bottommat = nil
    local mainmat = nil
    local lijstkleur= nil

    for i,v in ipairs(material_list) do
        if material_list[i][1] == data.material_bottom then
            bottommat = material_list[i][2]
        end
        if material_list[i][1] == data.material_main then
            mainmat = material_list[i][2]
        end
        if material_list[i][1] == data.opvullijst_kleur then
            lijstkleur = material_list[i][2]
        end
    end

    local lade_breedte = data.size[1]-(21-data.thickness_main)*2
    local lade_diepte = data.size[2]-10+data.thickness_main
    local lade_hoogte = data.size[3]
    
    local complete_width = data.size[1]

    if data.opvullijst_l and data.opvullijst_r then
        lade_breedte = lade_breedte - 50
        data.size[1] = data.size[1]- 50
    elseif data.opvullijst_l or data.opvullijst_r then
        lade_breedte = lade_breedte - 25
        data.size[1] = data.size[1] - 25
    end

    --bodem
    bodem = pytha.create_block(lade_breedte-10, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom, {(21-data.thickness_main)+5, data.thickness_main-5, 13.15}, {name = "Bodem"})
    lade = pytha.create_group(bodem, {name="KIMA internal drawer full front"})
    pytha.set_element_attributes(bodem, { material_name = bottommat })

    --voor
    voor = pytha.create_block(lade_breedte+4, data.thickness_main, lade_hoogte+16, {(21-data.thickness_main)-2, 0, -13}, {name = "Front"}) 
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    voor = pytha.boole_part_difference(voor, temp) 
    pytha.set_element_attributes(voor, { material_name = mainmat })
    pytha.set_element_group(voor, lade)

    --links
    links = pytha.create_block(data.thickness_main, lade_diepte-data.thickness_main, lade_hoogte, {(21-data.thickness_main), data.thickness_main, 0}, {name = "Linker zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    links = pytha.boole_part_difference(links, temp) 
    pytha.set_element_attributes(links, { material_name = mainmat })
    pytha.set_element_group(links, lade)

    --rechts
    rechts = pytha.create_block(data.thickness_main, lade_diepte-data.thickness_main, lade_hoogte, {lade_breedte-data.thickness_main+(21-data.thickness_main), data.thickness_main, 0}, {name = "Rechter zijwand"})
    temp = pytha.create_block(lade_breedte-8, lade_diepte-(data.thickness_main-5)*2, data.thickness_bottom+.3, {(21-data.thickness_main)+4, data.thickness_main-5, 13})
    rechts = pytha.boole_part_difference(rechts, temp) 
    pytha.set_element_attributes(rechts, { material_name = mainmat })
    pytha.set_element_group(rechts, lade)

    --achter
    if data.mat_massief == true then
        achter = pytha.create_block(lade_breedte-data.thickness_main*2, data.thickness_main,  lade_hoogte-2, {data.thickness_main+(21-data.thickness_main), lade_diepte-data.thickness_main-.5, 0}, {name = "Achterwand"})
    else
        achter = pytha.create_block(lade_breedte-data.thickness_main*2, data.thickness_main,  lade_hoogte, {data.thickness_main+(21-data.thickness_main), lade_diepte-data.thickness_main-.5, 0}, {name = "Achterwand"})
    end
    snedehandle = pyux.get_library_handle("library", "KIMA", "snede")

    if data.size[1] >= 250 then
        snede = pytha.import_pyo(snedehandle, {data.size[1]/2, lade_diepte+19.5-data.thickness_main, 0},{},{width = lade_breedte})
        achter=pytha.boole_part_difference(achter, snede)
    end

    pytha.set_element_attributes(achter, { material_name = mainmat })
    pytha.set_element_group(achter, lade)

    --geleider
    if lade_diepte <= 270 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_250270")
    elseif lade_diepte <= 350 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_300350")
    elseif lade_diepte <= 520 then
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_380520")
    else
        filehandle = pyux.get_library_handle("library", "KIMA", "geleider_550600")
    end

    geleider = pytha.import_pyo(filehandle, {0,22,-13.93}, {}, {g_b = data.size[1], g_d = data.size[2]-10}) 
    middelen = pytha.create_group(geleider, {name="blum movento"})

    pytha.move_element(lade, {0, 0, 1.42})

    ladegroep = pytha.create_group({lade, middelen}, {name = data.referentie}) 

    --OPVULLIJST(EN)
    if data.opvullijst_l or data.opvullijst_r then
        opvullijsten = pytha.create_group({}, {name = "Opvullijst(en)"})
        if data.opvullijst_l then
            opvullade_links = pytha.create_block(25, data.size[2]-10, 50, {-25, 22, -13.93}, {name = "Opvullijst links"})
            pytha.set_element_attributes(opvullade_links, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_links, opvullijsten)
        end 
        if data.opvullijst_r then
            if data.opvullijst_l then
                opvullade_rechts = pytha.create_block(25, data.size[2]-10, 50, {complete_width-50, 22, -13.93}, {name = "Opvullijst rechts"})
            else
                opvullade_rechts = pytha.create_block(25, data.size[2]-10, 50, {complete_width-25, 22, -13.93}, {name = "Opvullijst rechts"})
            end
            pytha.set_element_attributes(opvullade_rechts, { material_name = lijstkleur })
            pytha.set_element_group(opvullade_rechts, opvullijsten)
        end
        pytha.set_element_group(opvullijsten, ladegroep)
    end

    if data.ref_end == nil then
        pytha.create_element_ref_point(ladegroep, {complete_width, -5, -13.89}) 
    end

    if data.opvullijst_l then
        pytha.move_element(ladegroep, {data.origin[1]+25, data.origin[2]+5, data.origin[3]+13.89})
    else
        pytha.move_element(ladegroep, {data.origin[1], data.origin[2]+5, data.origin[3]+13.89})
    end

    pytha.rotate_element(ladegroep, data.origin, {0,0,100}, -data.rot_angle)

    pytha.create_element_ref_point(ladegroep, data.origin) 
    if data.rot_angle ~= nil and data.rot_angle ~= 0 and data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.ref_end[1]-(data.ref_start[1]-data.origin[1]), data.ref_end[2]-(data.ref_start[2]-data.origin[2]), data.origin[3]}) 
    elseif data.ref_end ~= nil then
        pytha.create_element_ref_point(ladegroep, {data.origin[1]+complete_width, data.origin[2], data.origin[3]}) 
    end

    data.corrected_width = data.size[1]
    data.size[1] = complete_width
    
    pytha.set_element_history(bodem, data, "lade_history_prt")
    pytha.set_element_history(ladegroep, data, "lade_history")
end
--------------------------------------------    END VOORTEGEN

function get_value(value)
    local default_values = pyio.load_values("default_values")
    if default_values ~= nil then
        for i, k in pairs(default_values) do
            if i == value then return k end
        end
    else
        return 2
    end
end

function get_materials(material_list)
    materialfile_handle = pyux.get_library_handle("library", "KIMA", "materials")
    materialfile = pytha.import_pyo(materialfile_handle, {0,0,0})
   for i,v in ipairs(materialfile) do
    table.insert(material_list, {pytha.get_element_attribute(materialfile[i], 3), pytha.get_element_attribute(materialfile[i], 9)})
    pytha.delete_element(materialfile[i])
  end
end
-------------------------------------
function round(num, numDecimalPlaces)
    if numDecimalPlaces and numDecimalPlaces > 0 then
      local mult = 10^numDecimalPlaces
      return math.floor(num * mult + 0.5) / mult
    end
    return math.floor(num + 0.5)
  end

function clear_data_file() --return true or false depending on if there are already parts of kima drawers in teh drawing. based on the drawer group names; attribute 59 of the elements
    for part in pytha.enumerate_parts() do
        if (pytha.get_element_attribute(part, 59) == "KIMA drawer" or pytha.get_element_attribute(part, 59) == "KIMA internal drawer C-handle" or pytha.get_element_attribute(part, 59) == "KIMA internal drawer full front") then 
            return true
        end
    end
    return false
end

-------------------------------------------------------------------------------------
---------------------------------KIMA WEBSHOP OUTPUT---------------------------------
-------------------------------------------------------------------------------------
function XMLout()
    xml = ""
    for part in pytha.enumerate_parts() do
        local lade_data = pytha.get_element_history(part, "lade_history_prt")
        if lade_data ~= nil then
            xml = xml .. generate_XML(lade_data)
        end
    end
    pyui.run_modal_dialog(giveXML_dialog, xml)
 end

 function generate_XML(data)
    local referentie = data.referentie
    local binnencorpus = round(data.corrected_width, 1)
    local diepte = data.size[2]
    local hoogte = data.size[3]
    local hoofdmateriaal = data.material_main
    local hoofddikte = data.thickness_main
    local bodemmateriaal = data.material_bottom
    local bodemdikte = data.thickness_bottom
    local ladetype = data.model
    local opvullijst_aantal = 0
    if data.opvullijst_l then opvullijst_aantal = opvullijst_aantal + 1 end
    if data.opvullijst_r then opvullijst_aantal = opvullijst_aantal + 1 end
    local opvullijst_kleur = data.opvullijst_kleur
    local gemonteerd
    if data.gemonteerd  then gemonteerd = "true" else gemonteerd = "false" end
    local geleider = data.geleider
    local synchronisatieset
    if data.synchronisatiestang  then synchronisatieset = "true" else synchronisatieset = "false" end
    local diepteversteller 
    if data.diepteversteller then diepteversteller = "true" else diepteversteller = "false" end
    local tipon_set = data.tip_on_set
    
    local xml_string = "<lade> <referentie> " .. referentie .. "</referentie> <type> " .. ladetype .. " </type> <hoofdmateriaal> " .. hoofdmateriaal .. 
    " </hoofdmateriaal> <hoofddikte> "  .. hoofddikte .. " </hoofddikte> <bodemmateriaal> " .. bodemmateriaal .. " </bodemmateriaal> <bodemdikte> " .. 
    bodemdikte .. " </bodemdikte> <binnencorpus> "  .. binnencorpus .. " </binnencorpus> <diepte> " .. diepte .. " </diepte> <hoogte> " .. hoogte .. 
    " </hoogte> <opvullijst_aantal> " .. opvullijst_aantal .. " </opvullijst_aantal> <opvullijst_kleur> " .. opvullijst_kleur .. 
    " </opvullijst_kleur> <gemonteerd> " .. gemonteerd .. " </gemonteerd> <geleider> " .. geleider .. " </geleider> <synchronisatiestang> " .. 
    synchronisatieset .. " </synchronisatiestang> <diepteversteller> " .. diepteversteller .. " </diepteversteller> <tip_on_set> " .. tipon_set .. 
    " </tip_on_set> </lade> " 
    return xml_string
  end

 function giveXML_dialog(dialog, xml)
    dialog:set_window_title(pyloc "KIMA webshop output")     
    local select_model = dialog:create_label({1,4}, pyloc "Kopieer de onderstaande text en plaats deze in het input field van de lade configurator in de KIMA webshop")
    local tekstplekkie = dialog:create_text_display({1,4}, xml)
    local ok = dialog:create_ok_button(1)
    local cancel = dialog:create_cancel_button(2)
 end
--------------------------------------------------------------------------------
function CSVout()
    local csv = ""
    local no_kima_parts = true
    for part in pytha.enumerate_parts() do
        local lade_data = pytha.get_element_history(part, "lade_history_prt")
        if lade_data ~= nil then
            csv = csv .. generate_csv(lade_data) .. " /n " --linebreak
            no_kima_parts = false
        end
    end
    if no_kima_parts then
		pyui.alert(pyloc "Error: no data found")
		return 
	end
    
    local q_res = pyui.run_modal_subdialog(givecsv_dialog, csv)
    if q_res == "ok" then 
        -- pyui.alert("OK")
        pyio.save_values("kima-drawer-file", {content = csv})
    -- else
    --     pyui.alert("NOT OK")
    end
 end

function givecsv_dialog(dialog, csv)
    dialog:set_window_title(pyloc "KIMA webshop output")     
    local ok = dialog:create_ok_button(1, "Download csv file")
    local cancel = dialog:create_cancel_button(2)
 end

 function generate_csv(data)
    local referentie = data.referentie
    local binnencorpus = round(data.corrected_width, 1)
    local diepte = data.size[2]
    local hoogte = data.size[3]
    local hoofdmateriaal = data.material_main
    local hoofddikte = data.thickness_main
    local bodemmateriaal = data.material_bottom
    local bodemdikte = data.thickness_bottom
    local ladetype = data.model
    local opvullijst_aantal = 0
    if data.opvullijst_l then opvullijst_aantal = opvullijst_aantal + 1 end
    if data.opvullijst_r then opvullijst_aantal = opvullijst_aantal + 1 end
    local opvullijst_kleur = data.opvullijst_kleur
    local gemonteerd
    if data.gemonteerd  then gemonteerd = "true" else gemonteerd = "false" end
    local geleider = data.geleider
    local synchronisatieset
    if data.synchronisatiestang  then synchronisatieset = "true" else synchronisatieset = "false" end
    local diepteversteller 
    if data.diepteversteller then diepteversteller = "true" else diepteversteller = "false" end
    local tipon_set
    if data.tip_on_set == "≤10kg" then
        tipon_set = "<10"
    elseif data.tip_on_set == "≤20kg" then
        tipon_set = "<20"
    elseif data.tip_on_set == "10 to 20kg" then
        tipon_set = "10-20"
    elseif data.tip_on_set == "15 to 40kg" then
        tipon_set = "15-40"
    elseif data.tip_on_set == "35 to 60kg" then
        tipon_set = "35-60"
    else
        tipon_set = data.tip_on_set
    end
    
    local csv_string = referentie .. ", " .. ladetype .. ", " .. hoofdmateriaal .. ", "  .. hoofddikte ..
    ", " .. bodemmateriaal .. ", " .. bodemdikte .. ", "  .. binnencorpus .. ", " .. diepte .. ", " .. 
    hoogte .. ", " .. opvullijst_aantal .. ", " .. opvullijst_kleur .. ", " .. gemonteerd .. ", " .. 
    geleider .. ", " .. synchronisatieset .. ", " .. diepteversteller .. ", " .. tipon_set 
    return csv_string
  end

 ----------------------------------------------------------------------------
 -----------------EDIT LADE FUNCTIE (RECHTERMUISKNOP -> EDIT)-----------------
 ----------------------------------------------------------------------------
function edit_lade(element, selected_element)
	local lade_data = pytha.get_element_history(element, "lade_history")
	if lade_data == nil then
		pyui.alert(pyloc "Error: no data found")
		return 
	end
    
    material_list = {}
    get_materials(material_list)

    pyui.run_modal_dialog(setModel_dialog, lade_data, true)
    pytha.delete_element(element)

    if lade_data.geleider == "40kg tip-on" or lade_data.geleider == "60kg tip-on" then 
        lade_data.synchronisatiestang = false
        lade_data.tip_on_set = "None"
    end

    if lade_data.model == "regulier" then
        create_lade_regulier(lade_data, material_list)
    elseif lade_data.model == "engels" then
        create_lade_engels(lade_data, material_list)
    elseif lade_data.model == "voortegen" then
        create_lade_voortegen(lade_data, material_list)
    end	
end

 ----------------------------------------------------------------------------
 ------------------------- CUSTOM ATTRIBUTE FUNCTIE -------------------------
 ----------------------------------------------------------------------------
function get_attr(element)
	local lade_data = pytha.get_element_history(element, "lade_history")
    if lade_data == nil or pytha.get_element_attribute(element, "name") ==  "Bodem" then
		return 
	end
    return generate_XML(lade_data)	
end